
var p I_o I_n prod_o prod_n F_o F_n X_o X_n theta_o theta_n VA mu_1_n mu_2_n o
    Y K L C r w beta_til a zeta_n zeta_o phi_n phi_o
    dp di_n di_o dq_n dq_o dy theta_o_lag;

varexo eps_zo eps_zn eps_po eps_pn eps_a;

parameters beta epsilon alpha xi eta psi lambda nu varphi delta s_o G_o G_n gamma
           rho_a1 rho_a2 a_var
           rho_zn1 rho_zn2 zn_var
           rho_zo1 rho_zo2 zo_var
           rho_pn1 rho_pn2 pn_var
           rho_po1 rho_po2 po_var
           th_o_ss F_o_ss;


%% Loading parameters

load calibration_parameters;

set_param_value('beta',struct_param.beta);             
set_param_value('epsilon',struct_param.epsilon);
set_param_value('alpha',struct_param.alpha);      
set_param_value('xi',struct_param.xi);  
set_param_value('eta',struct_param.eta);          
set_param_value('psi',struct_param.psi);
set_param_value('lambda',struct_param.lambda);        
set_param_value('nu',struct_param.nu);  
set_param_value('varphi',struct_param.varphi); 
set_param_value('delta',struct_param.delta); 
set_param_value('gamma',struct_param.gamma); 
set_param_value('s_o',struct_param.s_o); 
set_param_value('G_o',struct_param.G_o); 
set_param_value('G_n',struct_param.G_n); 


% Exogenous laws of motion parameters
set_param_value('rho_a1',shock_param.rho_a1);
set_param_value('rho_a2',shock_param.rho_a2);
set_param_value('a_var',shock_param.a_var);

set_param_value('rho_zn1',shock_param.rho_zn1);
set_param_value('rho_zn2',shock_param.rho_zn2);
set_param_value('zn_var',shock_param.zn_var);

set_param_value('rho_zo1',shock_param.rho_zo1);
set_param_value('rho_zo2',shock_param.rho_zo2);
set_param_value('zo_var',shock_param.zo_var);

set_param_value('rho_pn1',shock_param.rho_pn1);
set_param_value('rho_pn2',shock_param.rho_pn2);
set_param_value('pn_var',shock_param.pn_var);

set_param_value('rho_po1',shock_param.rho_po1);
set_param_value('rho_po2',shock_param.rho_po2);
set_param_value('po_var',shock_param.po_var);

% Steady state instruments
set_param_value('th_o_ss',endo_ss.theta_o); 
set_param_value('F_o_ss',endo_ss.F_o); 



%% Model
model;

% World Production Block (1-5)
exp(Y) = ((1-s_o)*exp((epsilon-1)/epsilon*a)*(exp(K(-1))^(alpha)*exp(L)^(1-alpha))^((epsilon-1)/epsilon)
          +s_o*exp(o)^((epsilon-1)/epsilon))^(epsilon/(epsilon-1));
exp(p) = s_o * exp(Y)^(1/epsilon)*exp(o)^(-1/epsilon);
exp(w) = (1-alpha)*(1-s_o)*exp((epsilon-1)/epsilon*a)*exp(Y)^(1/epsilon)*
         (exp(K(-1))^(alpha)*exp(L)^(1-alpha))^(-1/epsilon)
         *exp(K(-1))^(alpha)*exp(L)^(-alpha);
exp(r) = alpha*(1-s_o)*exp((epsilon-1)/epsilon*a)*exp(Y)^(1/epsilon)*
         (exp(K(-1))^(alpha)*exp(L)^(1-alpha))^(-1/epsilon)
         *exp(K(-1))^(alpha-1)*exp(L)^(1-alpha);
exp(VA)= exp((epsilon-1)/epsilon*a)*exp(alpha*K(-1))*exp((1-alpha)*L);

% Resource constraint (6)
exp(C) + exp(K) + exp(zeta_n)*exp(I_n) + exp(zeta_o)*exp(I_o) + exp(phi_o)*psi*exp(eta*theta_n(-1))*exp(F_n(-1))
 + exp(phi_n)*psi*exp(eta*(theta_o(-1)))*exp(F_o(-1)) = (1-delta)*exp(K(-1)) + exp(Y);

% Household Block (7-9)
exp(L) = varphi^(-1/nu) * exp(w)^(1/nu);
1 = exp(beta_til(+1))*(1+exp(r(+1))-delta);
exp(beta_til) = beta * (exp(C)      -varphi*exp(L)^(1+nu)    /(1+nu))^(-gamma) /
                       (exp(C(-1))  -varphi*exp(L(-1))^(1+nu)/(1+nu))^(-gamma);


% Non-OPEC optimality conditions (10-13)

mu_1_n = exp(beta_til(+1)) * (exp(theta_n) * exp(p(+1)) 
         + (1-exp(theta_n)) * mu_1_n(+1) - exp(phi_n(+1))*psi*exp(eta*theta_n));

mu_2_n = lambda * (mu_1_n) + exp(beta_til(+1)) * (1-lambda) * (mu_2_n(+1));

xi * exp((xi-1) * I_n) * G_n^(1-xi) * mu_2_n = exp(zeta_n);

exp(phi_n(+1)) * eta * psi * exp((eta-1)*theta_n)*exp(beta_til(+1)) = exp(beta_til(+1))*(exp(p(+1)) - mu_1_n(+1));


% Laws of motion for K and X, and production (14-20)

exp(F_n) = (1-exp(theta_n(-1))) * exp(F_n(-1)) + lambda * exp(X_n);
exp(F_o) = (1-exp(theta_o(-1))) * exp(F_o(-1)) + lambda * exp(X_o);

exp(X_n) = (1-lambda) * exp(X_n(-1))  + exp(xi * I_n) * G_n^(1-xi);
exp(X_o) = (1-lambda) * exp(X_o(-1))  + exp(xi * I_o) * G_o^(1-xi);

exp(prod_n) = exp(theta_n(-1)) * exp(F_n(-1));
exp(prod_o) = exp(theta_o(-1)) * exp(F_o(-1));

exp(o) = exp(prod_n) + exp(prod_o);

% Laws of motion for exogenous variables (21-22)

a = rho_a1 * a(-1) + rho_a2 * a(-2) + eps_a;

zeta_n = rho_zn1 * zeta_n(-1) + rho_zn2 * zeta_n(-2) + eps_zn;
zeta_o = rho_zo1 * zeta_o(-1) + rho_zo2 * zeta_o(-2) + eps_zo;
phi_n  = rho_pn1 * phi_n(-1)  + rho_pn2 * phi_n(-2)  + eps_pn;
phi_o  = rho_po1 * phi_o(-1)  + rho_po2 * phi_o(-2)  + eps_po;

% Defining lagged extraction for Ramsey objective (23)
exp(theta_o_lag) = exp(theta_o(-1));

% log changes (24-28)
dp = p - p(-1);
di_n = I_n - I_n(-1);
di_o = I_o - I_o(-1);
dq_n = prod_n - prod_n(-1);
dq_o = prod_o - prod_o(-1);
dy = Y - Y(-1);

end;

%% Initial Values
initval;
    F_o     = ln(F_o_ss);
    theta_o = ln(th_o_ss);
end;

steady_state_model;
    F_o     = F_o;
    theta_o = theta_o;
    theta_n = find_th_n(exp(F_o),exp(theta_o),beta, epsilon, alpha, xi, 
                eta, psi, lambda, nu, varphi, gamma, delta, s_o, G_o, G_n);

    r       = ln(1/beta - (1-delta));
    X_o     = ln(1/lambda * exp(F_o) * exp(theta_o));
    I_o     = (1/xi)*ln(lambda*exp(X_o)*G_o^(xi-1));
    mu_1_n  = beta/(1-beta)*(eta-1)*psi*exp(theta_n)^(eta);
    p       = ln(mu_1_n + eta*psi*exp(theta_n)^(eta-1));
    mu_2_n  = lambda/(1-beta*(1-lambda)) * mu_1_n;
    I_n     = (1/(1-xi))*ln(xi * G_n^(1-xi) * mu_2_n);
    X_n     = ln(1/lambda * exp(I_n)^(xi) * G_n^(1-xi));
    F_n     = -theta_n +ln(lambda) + X_n;
    o       = ln(exp(theta_n) * exp(F_n) + exp(theta_o) * exp(F_o));
    Y       = ln(s_o^(-epsilon)*exp(p)^(epsilon)*exp(o));
    VA      = (epsilon/(epsilon-1))*
        ln(1/(1-s_o)*(exp(Y)^((epsilon-1)/epsilon)-s_o*exp(o)^((epsilon-1)/epsilon)));
    L       = (1/(nu+1/alpha))*ln(exp(r)/varphi * (1-alpha)/alpha * exp(VA)^(1/alpha));
    K       = ln(exp(VA)^(1/alpha)*exp(L)^(1-1/alpha));
    C       = ln(exp(Y) - delta*exp(K) -exp(I_n) - exp(I_o) - psi*exp(theta_n)^eta*exp(F_n)
                 - psi*exp(theta_o)^eta*exp(F_o));
    w       = ln(varphi*exp(L)^(nu));
    beta_til= ln(beta);

    prod_n  = theta_n + F_n;
    prod_o  = theta_o + F_o;
    
    dp      = 0;
    di_n 	= 0;
    di_o 	= 0;
    dq_n 	= 0;
    dq_o 	= 0;
    a       = 0;
    zeta_n  = 0;
    zeta_o  = 0;
    phi_n   = 0;
    phi_o   = 0;
    dy      = 0;
    theta_o_lag = theta_o;

end;

%% Shocks
shocks;
    var eps_a  = a_var;
    var eps_zn = zn_var;
    var eps_zo = zo_var;
    var eps_pn = pn_var;
    var eps_po = po_var;

end;

%% Planner's objective
planner_objective((exp(C)-varphi*exp(L)^(1+nu)/(1+nu))^(-gamma)
                  *(exp(prod_o)*exp(p) 
                  - exp(phi_o)*psi*exp(theta_o_lag)^(eta-1)*exp(prod_o) 
                  - exp(zeta_o)*exp(I_o)));


%% Simulating the Model
ramsey_policy(planner_discount=beta,order=1, instruments=(F_o, theta_o), irf=0, nograph, AR = 20) dp di_n di_o dq_n dq_o dy;
